package dev.rusatom.keycloak.modules.esia;

import java.util.List;

import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Пользовательские аттрибуты необходимые для авторизации через
 *
 * @author Anatoliy Pokhresnyi
 */
public class EsiaUserAttributeMapper
        extends AbstractJsonUserAttributeMapper {
	protected static final Logger logger = Logger.getLogger(EsiaUserAttributeMapper.class);
	ObjectMapper om = new ObjectMapper();
    @Override
	public List<ProviderConfigProperty> getConfigProperties() {
    	try {
			logger.debug(om.writeValueAsString(super.getConfigProperties()));
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return super.getConfigProperties();
	}

	@Override
	public String getDisplayCategory() {
		try {
			logger.debug(om.writeValueAsString(super.getDisplayCategory()));
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}// TODO Auto-generated method stub
		return super.getDisplayCategory();
	}

	@Override
	public String getDisplayType() {
		try {
			logger.debug(om.writeValueAsString(super.getDisplayType()));
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}// TODO Auto-generated method stub
		return super.getDisplayType();
	}

	@Override
	public String getHelpText() {
		try {
			logger.debug(om.writeValueAsString(super.getHelpText()));
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}// TODO Auto-generated method stub
		return super.getHelpText();
	}

	@Override
	public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm,
			IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
		try {
			logger.debug(om.writeValueAsString(context));
			logger.debug(om.writeValueAsString(mapperModel));

		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.preprocessFederatedIdentity(session, realm, mapperModel, context);
	}

	@Override
	public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user,
			IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
		try {
			logger.debug(om.writeValueAsString(context));
			logger.debug(om.writeValueAsString(mapperModel));
			logger.debug(om.writeValueAsString(user));

		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.updateBrokeredUser(session, realm, user, mapperModel, context);
	}

	@Override
	public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user,
			IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
		try {
			logger.debug(om.writeValueAsString(context));
			logger.debug(om.writeValueAsString(mapperModel));
			logger.debug(om.writeValueAsString(user));

		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.importNewUser(session, realm, user, mapperModel, context);
	}

	/**
     * Список совместимых провайдеров.
     */
    private static final String[] COMPATIBLE_PROVIDERS = new String[]{EsiaIdentityProviderFactory.PROVIDER_ID};

    @Override
    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    @Override
    public String getId() {
        return "esia-user-attribute-mapper";
    }
}
