package dev.rusatom.keycloak.modules.esia;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;

/**
 *
 * @author Anatoliy Pokhresnyi
 */
public class EsiaIdentityProviderFactory
        extends AbstractIdentityProviderFactory<EsiaIdentityProvider>
        implements SocialIdentityProviderFactory<EsiaIdentityProvider> {

    /**
     * Уникальный идентификатор провайдера.
     */
    public static final String PROVIDER_ID = "esia";
	protected static final Logger logger = Logger.getLogger(EsiaIdentityProviderFactory.class);

    @Override
    public String getName() {
        return "ЕСИА";
    }

    @Override
    public EsiaIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new EsiaIdentityProvider(session, new EsiaIdentityProviderConfig(model));
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

	@Override
	public Map<String, String> parseConfig(KeycloakSession session, InputStream inputStream) {
		if(inputStream != null) {
			try {
				logger.debug(inputStream.available());
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else {
			logger.debug("inputStream was null");
		}
		return super.parseConfig(session, inputStream);
	}
    
    
}
